# Creating your own VNF package

This page illustrates how to create your own VNF package. As a previous step, it is highly convenient that you collect the internal structure of your VNF: its VDUs, the VDU information (flavor, interfaces, image, etc.), the VNF internal networks, and the external connection points. The presentation in this [link](https://osm-download.etsi.org/ftp/osm-3.0-three/1st-hackfest/presentations/20180117 OSM Hackfest - Guidelines for VNF builders.pptx) might help you collecting all the information.

## VNF without primitives

### Using the CLI tool

- Clone the devops repo:

```bash
git clone https://osm.etsi.org/gerrit/osm/devops
```

- Run the following command to create a folder with all the files required for a single-VM VNF package:

```bash
./devops/descriptor-packages/tools/generate_descriptor_pkg.sh -t vnfd --image <IMAGE_PATH> -c <VNF_NAME>
```

- A folder called `<VNF_NAME>_vnfd` will be created with all the files required for a VNF package.
- Edit the descriptor file `<VNF_NAME>_vnfd.yaml`.
  - By default, the descriptor is prepared for a single-VM VNF.
  - Add as many VMs as required.
  - Add also Internal VLDs as required.
- Add any artifacts needed by the VNF (eg, charm, icons, images etc ...) to the appropriate folder and make sure it is referenced in the descriptor.
- Once done, you can generate the tar.gz VNF package with the command:

```bash
./devops/descriptor-packages/tools/generate_descriptor_pkg.sh -t vnfd -N <VNF_NAME>_vnfd
#Note: the argument -N is optional and is intended to keep the package files after creating the package
```

## VNF with primitives

You will have to create a proxy charm for the VNF. You can follow the general instructions below:

- Clone the devops repo:

```bash
git clone https://osm.etsi.org/gerrit/osm/devops
```

- Enter the juju-charms folder under devops and follow the instructions to create your own charm: [Creating your own VNF charm](03-02-00-create-vnf-charm.md)

You can then follow the ping-pong example in OSM descriptor packages to integrate the charm into VNF primitives

## Migrating old descriptors to current release

Only file containing the VNFD or NSD descriptor need to be migrated. Clone the devops repo, run the utility for that and generate the package:

```bash
git clone https://osm.etsi.org/gerrit/osm/devops
./devops/descriptor-packages/tools/upgrade_descriptor_version.py -i <old-descriptor-file> -o <new-descriptor-file>
# generate package following the instructions of previous sections
```

This command fails if package python-osm-im is not installed. Follow these guidelines to install it: [Installing_Python_OSM_IM_package](#installing-python-osm-im-package)

## Validate descriptors

This utility is under the `devops` repository. Clone it using the above steps. Can be invoked with:

```bash
./devops/descriptor-packages/tools/validate_descriptor.py <DESCRIPTOR_FILE>
```

It is also integrated in the devops/descriptor-packages makefile system

```bash
make test
```

This command fails if package `python-osm-im` is not installed. Follow these guidelines to install it: [Installing_Python_OSM_IM_package](#installing-python-osm-im-package)

## Installing Python OSM IM package

Follow these steps to install it if needed:

```bash
# Check that the current OSM debian repository is the current stable repo for the release:
grep -h ^deb /etc/apt/sources.list /etc/apt/sources.list.d/* |grep osm-download
#  should be similar to this, and should include IM component:
#    deb [arch=amd64] https://osm-download.etsi.org/repository/osm/debian/ReleaseSIX stable IM osmclient devops

# If missing, add repository with:
curl "https://osm-download.etsi.org/repository/osm/debian/ReleaseSIX/OSM%20ETSI%20Release%20Key.gpg" | apt-key add -
apt-get update && add-apt-repository -y "deb [arch=amd64] https://osm-download.etsi.org/repository/osm/debian/ReleaseSIX stable IM osmclient devops"

# Install/update python-osm-im and its dependencies
apt-get update
apt-get install python-osm-im
sudo -H pip install pyangbind
```
